@echo off

echo Installing TeraFAST software.
if "%1". == "am_admin". GOTO getadmin

echo This batch file will install the following software:
echo TeraFAST software package including drivers for Opal Kelly XEM7001 controller;
echo Python v3.10 with packages Numpy, OpenCV, Pyserial, and wxPython for all users;
echo Microsoft Visual C++ Redistirbutable 2015
echo:
echo It requires admin privileges and would request them if necessary.
echo:
echo Press any key to install or Ctrl-C to cancel ...
pause > NUL 
echo:
echo Please, do not close the window!

if NOT "%1". == "am_admin". powershell start -verb runas '%0' am_admin & exit /b

:getadmin
cd /D %~dp0


setlocal
set APP=teraFAST
set SCRIPT=TeraFAST
set ICON=tera.ico



if /I "%PROCESSOR_ARCHITECTURE%". == "AMD64". GOTO amd64
:win32
	echo Installing 32-bit version
	for /f %%i in ('dir /b .\python\win32\python-3*.exe') do set PYTHON=win32\%%i
	set VC_REDISTR=vc_redist.x86.exe
	goto start
:amd64
	echo Installing 64-bit version
	for /f %%i in ('dir /b .\python\amd64\python-3*amd64.exe') do set PYTHON=amd64\%%i
	set VC_REDISTR=vc_redist.x64.exe
	goto start

:start

echo Installing Python...
.\python\%PYTHON%  /passive 
if ERRORLEVEL 1 echo Failed! & pause & exit /b 1

for /f %%i in ('dir /b driver\FrontPanelUSB-DriverOnly-*.exe') do set OKDRIVER=%%i
echo Installing OpalKelly driver...
.\driver\"%OKDRIVER%" /S
if ERRORLEVEL 1 echo Failed! & pause & exit /b 1

echo Installing VC 2015 Redistirbutable...
.\vc2015\"%VC_REDISTR%" /S

for /f "delims=;" %%i in ('py -c "import sys; print(sys.prefix)"') do set py_prefix=%%i
echo Installing packages...
"%py_prefix%\Scripts\pip3.exe"  install --no-index --no-warn-script-location --find-links=.\ --find-links=packages\  "%APP%"
if ERRORLEVEL 1 echo Failed! & pause & exit /b 1

echo Creating desktop shortcut...
( 
echo $Shortcut = ^^^(New-Object -ComObject WScript.Shell^^^).CreateShortcut^^^("$env:HOMEDRIVE\$env:HOMEPATH\Desktop\%SCRIPT%.lnk"^^^)
echo $Shortcut.Description = "TeraFAST Viewer App"
echo $Shortcut.TargetPath = '"%SystemRoot%\pyw.exe"'
echo $Shortcut.Arguments = '"%py_prefix%\Scripts\%SCRIPT%.pyw"'
echo $Shortcut.IconLocation  = "%py_prefix%\Lib\site-packages\teraFAST\gui\%ICON%"
echo $Shortcut.Save^^^(^^^) 
) | powershell -NoProfile -Command -

endlocal

echo All done!
pause
